unit CoreClassesUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Category = class;
  [UmlElement('Package')]
  [EcoCodeGenVersion('1.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Category))]
  CoreClasses = class
  public
  type
    [UmlElement('Association')]
    Association_1 = class
    end;
  type
    [UmlElement('Association')]
    [UmlTaggedValue('derived', 'True')]
    Association_2 = class
    end;
  type
    [UmlElement('AssociationEnd')]
    [UmlMetaAttribute('association', TypeOf(CoreClassesUnit.CoreClasses.Association_2), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..1')]
    Category_1 = class
    end;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]
  [UmlCollection(TypeOf(Category))]
  [EcoAutoGenerated]
  ICategoryList = interface
    function get_Count: Integer;
    function get_Item(index: Integer): Category;
    procedure set_Item(index: Integer; Value: Category);
    property Count: Integer read get_Count;
    property Item[index: Integer]: Category read get_Item write set_Item; default;
    procedure Clear;
    procedure RemoveAt(index: Integer);
    function Add(value: Category): Integer;
    function Contains(value: Category): Boolean;
    function IndexOf(value: Category): Integer;
    procedure Insert(index: Integer; value: Category);
    procedure Remove(value: Category);
  end;
  [UmlElement]
  [UmlTaggedValue('Eco.DefaultStringRepresentation', 'Name')]
  Category = class(System.Object, ILoopBack)
  strict protected
    [EcoAutoGenerated]
    _content: IContent;
    function get__Name: string;
    procedure set__Name(Value: string);
    [EcoAutoGenerated]
    property _Name: string read get__Name write set__Name;
    function get__Parent: Category;
    procedure set__Parent(Value: Category);
    [EcoAutoGenerated]
    property _Parent: Category read get__Parent write set__Parent;
    function get__Children: IList;
    [EcoAutoGenerated]
    property _Children: IList read get__Children;
    function get__Path: IList;
    [EcoAutoGenerated]
    property _Path: IList read get__Path;
  protected
  const
    CategoryFirstMember = 0;
  const
    CategoryMemberCount = (Category.CategoryFirstMember + 4);
  strict private
    {$REGION 'Autogenerated ECO code'}
  public
    [EcoAutoGenerated]
    function AsIObject: IObject;
    [EcoAutoGenerated]
    constructor Create(content: IContent); overload;
    [EcoAutoGenerated]
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    [EcoAutoGenerated]
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
  type
    [EcoAutoGenerated]
    CategoryListAdapter = class(ObjectListAdapter, ICategoryList)
    public
      constructor Create(source: IList);
      function Add(value: Category): Integer;
      function Contains(value: Category): Boolean;
      function IndexOf(value: Category): Integer;
      procedure Insert(index: Integer; value: Category);
      procedure Remove(value: Category);
      function get_Item(index: Integer): Category;
      procedure set_Item(index: Integer; value: Category);
    end;
    function get_Children: ICategoryList;
    [UmlElement('AssociationEnd', Index=(Category.CategoryFirstMember + 1))]
    [EcoAutoMaintained]
    [UmlMetaAttribute('association', TypeOf(CoreClassesUnit.CoreClasses.Association_1), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Children: ICategoryList read get_Children;
    function get_Parent: Category;
    procedure set_Parent(Value: Category);
    [UmlElement('AssociationEnd', Index=(Category.CategoryFirstMember + 2))]
    [EcoAutoMaintained]
    [UmlMetaAttribute('association', TypeOf(CoreClassesUnit.CoreClasses.Association_1), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..1')]
    property Parent: Category read get_Parent write set_Parent;
    function get_Name: string;
    procedure set_Name(Value: string);
    [UmlElement(Index=(Category.CategoryFirstMember + 0))]
    [EcoAutoMaintained]
    [UmlTaggedValue('derived', 'False')]
    property Name: string read get_Name write set_Name;
    function get_Path: ICategoryList;
    [UmlElement('AssociationEnd', Index=(Category.CategoryFirstMember + 3))]
    [EcoAutoMaintained]
    [UmlMetaAttribute('association', TypeOf(CoreClassesUnit.CoreClasses.Association_2), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    [UmlTaggedValue('Eco.DerivationOCL', 'if self.Parent.isNull then   self-' +
    '>asSet else    self.Parent.Path->including(self) endif')]
    property Path: ICategoryList read get_Path;
  strict protected
    [EcoAutoGenerated]
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    [EcoAutoGenerated]
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    [EcoAutoMaintained]
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation



function Category.AsIObject: IObject;
begin
  Result := Self._content.AsIObject;
end;

constructor Category.Create(content: IContent);
begin
  inherited Create;
  Self._content := content;
end;

function Category.get_MemberByIndex(index: Integer): System.Object;
begin
  case index of
    CategoryFirstMember + 0:
        result := System.Object(self.Name);
    CategoryFirstMember + 1:
        result := self.Children;
    CategoryFirstMember + 2:
        result := self.Parent;
    CategoryFirstMember + 3:
        result := self.Path;
    else
      raise System.IndexOutOfRangeException.Create();
  end;
end;

procedure Category.set_MemberByIndex(index: Integer; value: System.Object);
begin
  case index of
    CategoryFirstMember + 0:
      self.Name := string(value);
    CategoryFirstMember + 2:
      self.Parent := CoreClassesUnit.Category(value);
    else
      raise System.IndexOutOfRangeException.Create();
  end;
end;

procedure Category.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self._content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self._content := factory.CreateContent(Self);
  end;
end;

procedure Category.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self._content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self._content, Self);
    Self._content := nil;
  end;
end;
{$ENDREGION}

constructor Category.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Category.get__Path: IList;
begin
  Result := (IList(Self._content.get_MemberByIndex((CategoryFirstMember + 3))));
end;

function Category.get_Path: ICategoryList;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := CoreClassesUnit.Category.CategoryListAdapter.Create(Self._Path);
end;

function Category.get__Children: IList;
begin
  Result := (IList(Self._content.get_MemberByIndex((CategoryFirstMember + 1))));
end;

function Category.get__Parent: Category;
begin
  Result := (CoreClassesUnit.Category(Self._content.get_MemberByIndex((CategoryFirstMember 
      + 2))));
end;

procedure Category.set__Parent(Value: Category);
begin
  Self._content.set_MemberByIndex((CategoryFirstMember + 2), (System.Object(Value)));
end;

function Category.get_Parent: Category;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._Parent;
end;

procedure Category.set_Parent(Value: Category);
begin
  Self._Parent := Value;
end;

function Category.get__Name: string;
begin
  Result := (string(Self._content.get_MemberByIndex((CategoryFirstMember + 0))));
end;

procedure Category.set__Name(Value: string);
begin
  Self._content.set_MemberByIndex((CategoryFirstMember + 0), (System.Object(Value)));
end;

function Category.get_Name: string;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := Self._Name;
end;

procedure Category.set_Name(Value: string);
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Self._Name := Value;
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
end;

function Category.get_Children: ICategoryList;
begin
  // If you add user code here, please remove the [EcoAutoMaintained] attribute
  // from the property declaration in the interface section
  Result := CoreClassesUnit.Category.CategoryListAdapter.Create(Self._Children);
end;



constructor Category.CategoryListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Category.CategoryListAdapter.Add(value: Category): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Category.CategoryListAdapter.Contains(value: Category): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Category.CategoryListAdapter.IndexOf(value: Category): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Category.CategoryListAdapter.Insert(index: Integer; value: Category);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Category.CategoryListAdapter.Remove(value: Category);
begin
  Self.Adaptee.Remove(value);
end;

function Category.CategoryListAdapter.get_Item(index: Integer): Category;
begin
  Result := Category(Adaptee[index]);
end;

procedure Category.CategoryListAdapter.set_Item(index: Integer; value: Category);
begin
  Adaptee[index] := value;
end;

{ CoreClasses }




{ CoreClasses }




{ CoreClasses }










end.
