unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Borland.Eco.Windows.Forms, Borland.Eco.WinForm, Borland.Eco.Handles, ECOHirearchyTestEcoSpace, CoreClassesUnit;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    ehAllCategories: Borland.Eco.Handles.ExpressionHandle;
    grdAllCategories: System.Windows.Forms.DataGrid;
    cmhCurrentCategory: Borland.Eco.Handles.CurrencyManagerHandle;
    grdChildren: System.Windows.Forms.DataGrid;
    ehCategoryChildren: Borland.Eco.Handles.ExpressionHandle;
    ehCategoryAncestors: Borland.Eco.Handles.ExpressionHandle;
    DataGrid1: System.Windows.Forms.DataGrid;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    FEcoSpace: TECOHirearchyTestEcoSpace;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
    property EcoSpace: TECOHirearchyTestEcoSpace read FEcoSpace;
  end;

implementation

uses
  Borland.Eco.ObjectRepresentation, Borland.Eco.Services;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.ehAllCategories := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.grdAllCategories := System.Windows.Forms.DataGrid.Create;
  Self.cmhCurrentCategory := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.grdChildren := System.Windows.Forms.DataGrid.Create;
  Self.ehCategoryChildren := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.ehCategoryAncestors := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.DataGrid1 := System.Windows.Forms.DataGrid.Create;
  (System.ComponentModel.ISupportInitialize(Self.grdAllCategories)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.grdChildren)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).BeginInit;
  Self.SuspendLayout;
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(ECOHirearchyTestEcoSpace.TECOHirearchyTestEcoSpace);
  // 
  // ehAllCategories
  // 
  Self.ehAllCategories.Expression := 'Category.allInstances';
  Self.ehAllCategories.RootHandle := Self.rhRoot;
  // 
  // grdAllCategories
  // 
  Self.grdAllCategories.CaptionText := 'All Categories';
  Self.grdAllCategories.DataMember := '';
  Self.grdAllCategories.DataSource := Self.ehAllCategories;
  Self.grdAllCategories.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.grdAllCategories.Location := System.Drawing.Point.Create(16, 16);
  Self.grdAllCategories.Name := 'grdAllCategories';
  Self.grdAllCategories.Size := System.Drawing.Size.Create(208, 208);
  Self.grdAllCategories.TabIndex := 0;
  // 
  // cmhCurrentCategory
  // 
  Self.cmhCurrentCategory.BindingContext := Self.grdAllCategories;
  Self.cmhCurrentCategory.RootHandle := Self.ehAllCategories;
  // 
  // grdChildren
  // 
  Self.grdChildren.CaptionText := 'Selected Category''s Children';
  Self.grdChildren.DataMember := '';
  Self.grdChildren.DataSource := Self.ehCategoryChildren;
  Self.grdChildren.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.grdChildren.Location := System.Drawing.Point.Create(16, 232);
  Self.grdChildren.Name := 'grdChildren';
  Self.grdChildren.Size := System.Drawing.Size.Create(208, 224);
  Self.grdChildren.TabIndex := 1;
  // 
  // ehCategoryChildren
  // 
  Self.ehCategoryChildren.Expression := 'self.Children';
  Self.ehCategoryChildren.RootHandle := Self.cmhCurrentCategory;
  // 
  // ehCategoryAncestors
  // 
  Self.ehCategoryAncestors.Expression := 'self.Path';
  Self.ehCategoryAncestors.RootHandle := Self.cmhCurrentCategory;
  // 
  // DataGrid1
  // 
  Self.DataGrid1.CaptionText := 'Selected Category''s Path';
  Self.DataGrid1.DataMember := '';
  Self.DataGrid1.DataSource := Self.ehCategoryAncestors;
  Self.DataGrid1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGrid1.Location := System.Drawing.Point.Create(240, 232);
  Self.DataGrid1.Name := 'DataGrid1';
  Self.DataGrid1.Size := System.Drawing.Size.Create(192, 224);
  Self.DataGrid1.TabIndex := 2;
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(448, 467);
  Self.Controls.Add(Self.DataGrid1);
  Self.Controls.Add(Self.grdChildren);
  Self.Controls.Add(Self.grdAllCategories);
  Self.Name := 'TWinForm';
  Self.Text := 'TWinForm';
  Include(Self.Load, Self.TWinForm_Load);
  (System.ComponentModel.ISupportInitialize(Self.grdAllCategories)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.grdChildren)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;


  FEcoSpace :=  TECOHirearchyTestEcoSpace.Create;
  rhRoot.EcoSpace := FEcoSpace;
  
  // The line below will automatically activate the ECO Space on form create.
  // Remove the line if you wish to activate it manually

  FEcoSpace.Active := True;
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
var
  tmpCategory, tmpParent: Category;
begin
  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '1';
  tmpParent := tmpCategory;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '1.1';
  tmpCategory.Parent := tmpParent;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '1.2';
  tmpCategory.Parent := tmpParent;
  tmpParent := tmpCategory;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '1.2.1';
  tmpCategory.Parent := tmpParent;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '1.2.2';
  tmpCategory.Parent := tmpParent;
  tmpParent := tmpCategory;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '1.2.2.1';
  tmpCategory.Parent := tmpParent;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '2';
  tmpParent := tmpCategory;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '2.1';
  tmpCategory.Parent := tmpParent;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '2.2';
  tmpCategory.Parent := tmpParent;

  tmpCategory := Category.Create(EcoSpace);
  tmpCategory.Name := '3';
end;

end.
